<?php
// application/controllers/Api_nominatim.php
// Endpoint proxy untuk pencarian alamat Nominatim

class Api_nominatim extends CI_Controller {
    public function search() {
        $query = $this->input->get('q');
        if (!$query) {
            echo json_encode([]);
            return;
        }
        $url = 'https://nominatim.openstreetmap.org/search?q=' . urlencode($query) . '&format=json&addressdetails=1&limit=3';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'pendaftaran-seni/1.0'); // User-Agent wajib
        $result = curl_exec($ch);
        curl_close($ch);
        header('Content-Type: application/json');
        echo $result;
    }

    public function reverse() {
        $lat = $this->input->get('lat');
        $lon = $this->input->get('lon');
        if (!$lat || !$lon) {
            echo json_encode([]);
            return;
        }
        $url = 'https://nominatim.openstreetmap.org/reverse?lat=' . urlencode($lat) . '&lon=' . urlencode($lon) . '&format=json';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'pendaftaran-seni/1.0');
        $result = curl_exec($ch);
        curl_close($ch);
        header('Content-Type: application/json');
        echo $result;
    }
}
