<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuesioner Kepuasan Layanan Kesekretariatan</title>
   
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="<?php echo base_url('assets/css/style.css'); ?>">

    <style>
        /* ==========================================================================
           CSS untuk Tampilan Kuesioner yang Lebih Menarik (Diperbarui)
           ========================================================================== */
       
        /* Pengaturan Global */
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #1abc9c, #2ecc71, #3498db);
            background-size: 200% 200%;
            animation: gradient-animation 10s ease infinite;
            min-height: 100vh;
            padding: 20px;
            margin: 0;
            color: #34495e;
        }

        /* Animasi gradasi warna */
        @keyframes gradient-animation {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Wrapper utama kuesioner */
        .kuesioner-wrapper {
            background-color: #ffffff;
            max-width: 900px;
            margin: 30px auto;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        /* Header Kuesioner */
        .kuesioner-header {
            margin-bottom: 40px;
            text-align: center;
        }

        .kuesioner-header h1 {
            font-weight: 700;
            color: #34495e;
            font-size: 2.5rem;
            line-height: 1.2;
            margin-bottom: 20px;
        }

        .kuesioner-header .header-divider {
            width: 80px;
            height: 4px;
            background-color: #34495e;
            margin: 0 auto;
            border-radius: 2px;
        }

        .kuesioner-header .subtitle {
            font-weight: 600;
            color: #7f8c8d;
            font-size: 1.1rem;
            margin-bottom: 5px;
        }

        .kuesioner-header .instruction {
            font-weight: 400;
            color: #95a5a6;
            font-size: 1rem;
            margin: 0;
        }

        /* Styling untuk Formulir */
        .card {
            border: none;
            border-radius: 10px;
        }

        .form-group label {
            font-weight: 600;
            color: #34495e;
        }

        /* Styling untuk item penilaian */
        .item-penilaian-group {
            border: 1px solid #ccc;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
            background-color: #f9f9f9;
            transition: border-color 0.3s ease;
        }

        .item-penilaian-group.is-invalid-group {
            border: 2px solid #dc3545;
            background-color: #ffecec;
        }

        .item-penilaian-group h5 {
            font-size: 1.1rem;
            font-weight: 600;
            color: #34495e;
            margin-bottom: 15px;
        }

        /* ==========================================================================
           PENGATURAN SPESIFIK UNTUK BAGIAN PENILAIAN (EMOTICON/ANGKA) - PERBAIKAN
           ========================================================================== */
       
        .rating-row {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }

        .rating-label-wrapper {
            font-weight: 500;
            color: #555;
            flex-basis: 15%;
            text-align: left;
            padding-right: 15px;
        }
       
        .rating-options-container {
            flex: 1;
        }
       
        .radio-group-wrapper {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 5px;
            width: 100%;
        }

        .radio-item {
            width: 100%;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 5px;
            position: relative;
        }
       
        .form-check-input.rating-radio {
            opacity: 0;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
            z-index: 2;
        }
       
        .emoji-label {
            font-size: 3rem;
            opacity: 0.5;
            transition: transform 0.2s ease, opacity 0.2s ease;
        }

        .number-label {
            font-size: 2.5rem;
            font-weight: 700;
            color: #555;
            opacity: 0.5;
            transition: transform 0.2s ease, opacity 0.2s ease;
        }
       
        .form-check-label-emoji {
            font-size: 0.9rem;
            color: #7f8c8d;
            font-weight: 400;
            margin-top: 5px;
            z-index: 1;
            transition: color 0.2s ease;
        }
       
        .radio-item:hover .emoji-label,
        .radio-item:hover .number-label {
            transform: scale(1.1);
            opacity: 0.8;
        }
       
        .form-check-input.rating-radio:checked + .emoji-label,
        .form-check-input.rating-radio:checked + .number-label {
            transform: scale(1.2);
            opacity: 1;
            filter: drop-shadow(0 0 5px rgba(0,0,0,0.3));
        }

        .form-check-input.rating-radio:checked ~ .form-check-label-emoji {
            color: #34495e;
            font-weight: 600;
        }

        /* Tambahan CSS untuk Tanda Error */
        .is-invalid {
            border-color: #dc3545 !important;
        }
       
        .is-invalid + .text-danger {
            display: block !important;
        }
       
        .item-penilaian-group.is-invalid-group {
            border: 2px solid #dc3545;
            background-color: #ffecec;
        }

        /* Styling untuk Tombol */
        .btn-primary {
            background-color: #3498db;
            border-color: #3498db;
            font-weight: 600;
            padding: 10px 25px;
            border-radius: 50px;
            transition: background-color 0.3s ease, transform 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #2980b9;
            border-color: #2980b9;
            transform: translateY(-2px);
        }
       
        /* ==========================================================================
           Responsif untuk Tampilan Mobile (Perbaikan)
           ========================================================================== */
        @media (max-width: 767px) {
            body { padding: 10px; }
            .kuesioner-wrapper {
                margin: 0;
                padding: 20px;
                border-radius: 0;
                box-shadow: none;
            }
            .kuesioner-header h1 { font-size: 1.5rem; }
            .item-penilaian-group { padding: 15px; }
            .item-penilaian-group h5 { font-size: 1rem; }
           
            .rating-row {
                flex-direction: column;
                align-items: flex-start;
                padding-left: 0 !important;
                padding-right: 0 !important;
            }
            .rating-label-wrapper {
                flex-basis: auto;
                margin-bottom: 10px;
                text-align: left !important;
            }
            .rating-options-container {
                width: 100%;
            }
           
            .radio-group-wrapper {
                grid-template-columns: repeat(4, 1fr);
                gap: 5px;
            }
           
            .radio-item {
                padding: 0 5px;
            }
           
            .emoji-label { font-size: 2rem; }
            .number-label { font-size: 1.5rem; }
            .form-check-label-emoji { font-size: 0.75rem; }
        }
    </style>
</head>
<body>
    <div class="container kuesioner-wrapper py-5">
        <div class="text-center mb-4 kuesioner-header">
            <h1 class="h3 font-weight-bold">KUESIONER NILAI KEPUASAN PEGAWAI TERHADAP LAYANAN KESEKRETARIATAN</h1>
            <div class="header-divider"></div>
            <p class="subtitle mt-3">Petunjuk Pengisian:</p>
            <p class="instruction">Berikan tanda (✓) pada jawaban yang sesuai dengan pendapat Anda.</p>
            <p class="instruction">Skala 1 = Tidak Puas, 2 = Cukup Puas, 3 = Puas, 4 = Sangat Puas.</p>
        </div>

        <?php if ($this->session->flashdata('success_msg')): ?>
            <div class="alert alert-success text-center">
                <?= htmlspecialchars($this->session->flashdata('success_msg')) ?>
            </div>
        <?php elseif ($this->session->flashdata('error_msg')): ?>
            <div class="alert alert-danger text-center">
                <?= htmlspecialchars($this->session->flashdata('error_msg')) ?>
            </div>
        <?php endif; ?>

        <?php echo form_open('kuesioner/submit', ['class' => 'mt-4']); ?>

        <div id="step-1">
            <div class="card p-4 mb-4">
                <h4 class="mb-3">A. Data Responden</h4>
                <div class="form-group">
                    <label for="nama">Nama: <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="nama" name="nama" value="<?php echo set_value('nama'); ?>" placeholder="Masukkan Nama Anda">
                    <?php echo form_error('nama', '<div class="text-danger mt-2">', '</div>'); ?>
                </div>
                <div class="form-group">
                    <label>Jenis Kelamin: <span class="text-danger">*</span></label>
                    <div class="d-flex flex-wrap" id="jenis-kelamin-group">
                        <div class="form-check mr-3">
                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="jk_l" value="Laki-laki" <?php echo set_radio('jenis_kelamin', 'Laki-laki'); ?>>
                            <label class="form-check-label" for="jk_l">Laki-laki</label>
                        </div>
                        <div class="form-check mr-3">
                            <input class="form-check-input" type="radio" name="jenis_kelamin" id="jk_p" value="Perempuan" <?php echo set_radio('jenis_kelamin', 'Perempuan'); ?>>
                            <label class="form-check-label" for="jk_p">Perempuan</label>
                        </div>
                    </div>
                    <?php echo form_error('jenis_kelamin', '<div class="text-danger mt-2">', '</div>'); ?>
                </div>
                <div class="form-group mt-0">
                    <label for="id_bidang" class="mb-1">Nama Bidang: <span class="text-danger">*</span></label>
                    <select class="form-control" id="id_bidang" name="id_bidang">
                        <option value="">-- Pilih Bidang --</option>
                        <?php if (!empty($bidang_options)): ?>
                            <?php foreach ($bidang_options as $bidang): ?>
                                <option value="<?php echo htmlspecialchars($bidang->id_bidang); ?>" <?php echo set_select('id_bidang', $bidang->id_bidang); ?>>
                                    <?php echo htmlspecialchars($bidang->nama_bidang); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <option value="">Tidak ada bidang ditemukan</option>
                        <?php endif; ?>
                    </select>
                    <?php echo form_error('id_bidang', '<div class="text-danger mt-2">', '</div>'); ?>
                </div>
            </div>
            <div class="text-center mb-5">
                <button type="button" class="btn btn-primary btn-lg" onclick="nextStep()">Lanjut ke Penilaian</button>
            </div>
        </div>

        <div id="step-2" class="d-none">
            <div class="card p-4 mb-4">
                <h4 class="mb-3">B. Penilaian Fasilitas <span class="text-danger">*</span></h4>
                <?php
                    $emojis = [
                        1 => ['emoji' => '😠', 'text' => 'Tidak Puas'],
                        2 => ['emoji' => '😐', 'text' => 'Cukup Puas'],
                        3 => ['emoji' => '😊', 'text' => 'Puas'],
                        4 => ['emoji' => '😁', 'text' => 'Sangat Puas']
                    ];
                ?>
               
                <?php if (!empty($pertanyaan)): $no = 1; foreach ($pertanyaan as $row): ?>
                    <div class="item-penilaian-group" data-id-pertanyaan="<?php echo $row['id_pertanyaan']; ?>">
                        <h5 class="mb-3"><?php echo $no++ . '. ' . (isset($row['teks_pertanyaan']) ? htmlspecialchars($row['teks_pertanyaan']) : '[Pertanyaan tidak ditemukan]'); ?></h5>
                       
                        <div class="rating-row">
    <div class="rating-label-wrapper">Harapan</div>
    <div class="rating-options-container">
        <div class="radio-group-wrapper">
            <?php for ($i = 1; $i <= 4; $i++): ?>
                <div class="radio-item">
                    <input class="form-check-input rating-radio" 
                           type="radio" 
                           name="harapan[<?php echo $row['id_pertanyaan']; ?>]" 
                           id="harapan_<?php echo $row['id_pertanyaan'] . '_' . $i; ?>" 
                           value="<?php echo $i; ?>" 
                           <?php echo set_radio('harapan[' . $row['id_pertanyaan'] . ']', $i); ?>>
                    
                    <span class="number-label"><?php echo $i; ?></span>
                    <!-- 🔴 Ganti label bawah jadi 'Pilih Nilai' -->
                    <label class="form-check-label-emoji" 
                           for="harapan_<?php echo $row['id_pertanyaan'] . '_' . $i; ?>">
                        Pilih Nilai
                    </label>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>

                       
                        <div class="rating-row">
                            <div class="rating-label-wrapper">Kenyataan</div>
                            <div class="rating-options-container">
                                <div class="radio-group-wrapper">
                                    <?php for ($i = 1; $i <= 4; $i++): ?>
                                        <div class="radio-item">
                                            <input class="form-check-input rating-radio" type="radio" name="kenyataan[<?php echo $row['id_pertanyaan']; ?>]" id="kenyataan_<?php echo $row['id_pertanyaan'] . '_' . $i; ?>" value="<?php echo $i; ?>" <?php echo set_radio('kenyataan[' . $row['id_pertanyaan'] . ']', $i); ?>>
                                            <span class="emoji-label"><?php echo $emojis[$i]['emoji']; ?></span>
                                            <label class="form-check-label-emoji" for="kenyataan_<?php echo $row['id_pertanyaan'] . '_' . $i; ?>"><?php echo $emojis[$i]['text']; ?></label>
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; endif; ?>
            </div>

            <div class="card p-4 mb-4">
                <h4 class="mb-3">C. Masukan & Saran</h4>
                <div class="form-group mb-4">
                    <label for="jawaban_memuaskan">Apa yang paling memuaskan Anda dari layanan kesekretariatan? <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="jawaban_memuaskan" name="jawaban_memuaskan" rows="4" placeholder="Tuliskan hal-hal yang paling memuaskan Anda..."><?php echo set_value('jawaban_memuaskan'); ?></textarea>
                    <?php echo form_error('jawaban_memuaskan', '<div class="text-danger mt-2">', '</div>'); ?>
                </div>

                <div class="form-group">
                    <label for="jawaban_peningkatan">Bagian mana dari layanan yang perlu peningkatan? <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="jawaban_peningkatan" name="jawaban_peningkatan" rows="4" placeholder="Tuliskan masukan untuk peningkatan layanan..."><?php echo set_value('jawaban_peningkatan'); ?></textarea>
                    <?php echo form_error('jawaban_peningkatan', '<div class="text-danger mt-2">', '</div>'); ?>
                </div>
            </div>
           
            <div class="d-flex justify-content-between mt-5">
                <button type="button" class="btn btn-secondary btn-lg" onclick="prevStep()">Kembali</button>
                <button type="submit" class="btn btn-primary btn-lg">Kirim Kuesioner</button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
   
    <script>
        function resetValidationErrors() {
            document.querySelectorAll('#step-1 .is-invalid').forEach(el => el.classList.remove('is-invalid'));
            document.querySelectorAll('#step-1 .text-danger.mt-2').forEach(el => el.remove());
            document.querySelectorAll('#step-2 .is-invalid').forEach(el => el.classList.remove('is-invalid'));
            document.querySelectorAll('#step-2 .text-danger.mt-2').forEach(el => el.remove());
            document.querySelectorAll('.item-penilaian-group.is-invalid-group').forEach(item => {
                item.classList.remove('is-invalid-group');
            });
        }
   
        function nextStep() {
            resetValidationErrors();
            let isValid = true;
            let firstInvalidElement = null;

            // Validasi Step 1
            const namaInput = document.getElementById('nama');
            if (namaInput.value.trim() === '') {
                namaInput.classList.add('is-invalid');
                namaInput.parentElement.insertAdjacentHTML('beforeend', '<div class="text-danger mt-2">Nama wajib diisi.</div>');
                isValid = false;
                if (!firstInvalidElement) firstInvalidElement = namaInput;
            }

            const jkChecked = document.querySelector('input[name="jenis_kelamin"]:checked');
            if (!jkChecked) {
                const jkGroup = document.getElementById('jenis-kelamin-group');
                jkGroup.parentElement.insertAdjacentHTML('beforeend', '<div class="text-danger mt-2">Jenis kelamin wajib dipilih.</div>');
                isValid = false;
                if (!firstInvalidElement) firstInvalidElement = jkGroup;
            }
           
            const bidangInput = document.getElementById('id_bidang');
            if (bidangInput.value === '') {
                bidangInput.classList.add('is-invalid');
                bidangInput.parentElement.insertAdjacentHTML('beforeend', '<div class="text-danger mt-2">Nama bidang wajib dipilih.</div>');
                isValid = false;
                if (!firstInvalidElement) firstInvalidElement = bidangInput;
            }
           
            if (!isValid) {
                if (firstInvalidElement) {
                    firstInvalidElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
                return;
            }

            document.getElementById('step-1').classList.add('d-none');
            document.getElementById('step-2').classList.remove('d-none');
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        function prevStep() {
            resetValidationErrors();
            document.getElementById('step-2').classList.add('d-none');
            document.getElementById('step-1').classList.remove('d-none');
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        document.querySelector('form').addEventListener('submit', function (e) {
            e.preventDefault();
            let isValid = true;
            let firstInvalidElement = null;

            resetValidationErrors();

            // Validasi Step 2
            const pertanyaanIDs = <?php echo json_encode(array_column($pertanyaan, 'id_pertanyaan')); ?>;
            pertanyaanIDs.forEach(id => {
                const harapan = document.querySelector(`input[name="harapan[${id}]"]:checked`);
                const kenyataan = document.querySelector(`input[name="kenyataan[${id}]"]:checked`);
                if (!harapan || !kenyataan) {
                    const group = document.querySelector(`[data-id-pertanyaan="${id}"]`);
                    if (group) {
                        group.classList.add('is-invalid-group');
                        if (!firstInvalidElement) {
                            firstInvalidElement = group;
                        }
                    }
                    isValid = false;
                }
            });

            const jawabanMemuaskan = document.getElementById('jawaban_memuaskan');
            if (jawabanMemuaskan.value.trim() === '') {
                jawabanMemuaskan.classList.add('is-invalid');
                jawabanMemuaskan.parentElement.insertAdjacentHTML('beforeend', '<div class="text-danger mt-2">Masukan ini wajib diisi.</div>');
                isValid = false;
                if (!firstInvalidElement) firstInvalidElement = jawabanMemuaskan;
            }

            const jawabanPeningkatan = document.getElementById('jawaban_peningkatan');
            if (jawabanPeningkatan.value.trim() === '') {
                jawabanPeningkatan.classList.add('is-invalid');
                jawabanPeningkatan.parentElement.insertAdjacentHTML('beforeend', '<div class="text-danger mt-2">Masukan ini wajib diisi.</div>');
                isValid = false;
                if (!firstInvalidElement) firstInvalidElement = jawabanPeningkatan;
            }

            if (!isValid) {
                if (firstInvalidElement) {
                    firstInvalidElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            } else {
                this.submit();
            }
        });
    </script>
</body>
</html>