<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuesioner Kepuasan Fasilitas</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            /* PERBAIKAN: Gradasi warna biru-kuning seperti logo DISBUDPAR */
            background: linear-gradient(135deg, #007bff, #ffc107); /* Ini yang diganti */
            background-size: 200% 200%;
            animation: gradient-animation 10s ease infinite;
            
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
            color: #ffffff;
            text-align: center;
            padding: 20px;
        }

        /* Animasi gradasi warna */
        @keyframes gradient-animation {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        /* Animasi masuk untuk teks */
        @keyframes slideDown {
            0% { opacity: 0; transform: translateY(-30px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        /* Animasi masuk untuk logo */
        @keyframes fadeInScale {
            0% { opacity: 0; transform: scale(0.8); }
            100% { opacity: 1; transform: scale(1); }
        }

        /* Animasi masuk untuk tombol */
        @keyframes fadeInUp {
            0% { opacity: 0; transform: translateY(20px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        .intro-container {
            max-width: 600px;
        }

        .intro-container h1 {
            font-weight: 700;
            font-size: 25px;
            line-height: 1.2;
            margin-bottom: 10px;
            animation: slideDown 1s ease forwards;
        }

        .intro-container p {
            font-size: 15px;
            margin-bottom: 20px;
            animation: fadeInUp 1.2s ease forwards;
        }

        /* Pembungkus logo otomatis sesuai ukuran logo */
        .logo-container {
            display: inline-block; /* ngepasin ukuran sama konten di dalamnya */
            background: linear-gradient(135deg, #1abc9c, #2ecc71, #3498db);
            border-radius: 30px;
            padding: 25px; 
            margin: 20px auto;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
            animation: fadeInScale 1.2s ease forwards;
        }

        /* Logo fleksibel */
        .logo-image {
            max-width: 100%;
            max-height: 80px; /* batas maksimal tinggi, biar nggak kegedean */
            height: auto;
            width: auto;
            display: block;
        }


        /* Tombol */
        .btn-start {
            background-color: rgba(255, 255, 255, 0.2);
            border: 2px solid #ffffff;
            color: #ffffff;
            font-weight: 600;
            padding: 12px 35px;
            border-radius: 50px;
            font-size: 15px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            animation: fadeInUp 1.4s ease forwards;
        }
        .btn-start:hover {
            background-color: rgba(255, 255, 255, 0.4);
            transform: translateY(-2px) scale(1.05);
            box-shadow: 0 0 15px white;
            color: #ffffff;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="intro-container">
        <h1>SELAMAT DATANG DI KUESIONER KEPUASAN FASILITAS</h1>

        <div class="logo-container">
            <img src="<?php echo base_url('assets/img/logo_budpar.png'); ?>" alt="Logo Kuesioner" class="logo-image">
        </div>
        
        <p>Suara Anda sangat berharga untuk perbaikan terhadap layanan kesekretariatan.</p>

        <a href="<?php echo site_url('kuesioner'); ?>" class="btn-start">Mulai Mengisi Kuesioner</a>
    </div>
</body>
</html>