<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/admin_header'); ?>

<div class="ml-[350px] mt-16 p-6">
    <h1 class="text-2xl font-bold mb-4">Pertanyaan Terbuka</h1>
     <form action="<?= site_url('admin/pertanyaan_terbuka'); ?>" method="GET" class="flex items-center space-x-2">
                <label for="search" class="sr-only">Cari</label>
                <input type="text" id="search" name="search" placeholder="Cari berdasarkan nama responden..." 
                    class="form-input flex-grow max-w-md border border-gray-300 rounded-md px-3 py-2 focus:ring-blue-500 focus:border-blue-500">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition">
                    🔍 Cari
                </button>
                <a href="<?= site_url('admin/pertanyaan_terbuka'); ?>" class="bg-gray-400 text-white px-4 py-2 rounded-md hover:bg-gray-500 transition">
                    Reset
                </a>
         </form>
    <div class="mb-4 flex gap-2">
    <a href="<?= site_url('admin/export_pertanyaan_terbuka_excel') ?>" 
       class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Download Excel</a>
    <a href="<?= site_url('admin/export_pertanyaan_terbuka_pdf') ?>" 
       class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">Download PDF</a>
</div>
    <div class="bg-white p-6 rounded-xl shadow mb-6">
        <div class="overflow-x-auto">
            <table class="min-w-full border-collapse border border-gray-200">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border px-4 py-2">No</th>
                        <th class="border px-4 py-2">Nama Responden</th>
                        <th class="border px-4 py-2">Tanggal</th>
                        <th class="border px-4 py-2">Jawaban Paling Memuaskan</th>
                        <th class="border px-4 py-2">Jawaban Perlu Peningkatan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($jawaban_terbuka_gabung)): ?>
                        <?php $no = 1; foreach ($jawaban_terbuka_gabung as $j): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="border px-4 py-2"><?= $no++ ?></td>
                                <td class="border px-4 py-2"><?= htmlspecialchars($j->nama_responden) ?></td>
                                <td class="border px-4 py-2"><?= date('d-m-Y', strtotime($j->tanggal_pengisian)) ?></td>
                                <td class="border px-4 py-2"><?= nl2br(htmlspecialchars($j->jawaban_memuaskan)) ?></td>
                                <td class="border px-4 py-2"><?= nl2br(htmlspecialchars($j->jawaban_peningkatan)) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center py-4">Tidak ada jawaban terbuka.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>