<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kuesioner_model extends CI_Model {

    public function search_bidang($term) {
        $this->db->like('nama_bidang', $term);
        $query = $this->db->get('bidang');
        return $query->result();
    }

    // --- Fungsi baru untuk mendapatkan nama bidang berdasarkan ID ---
    public function get_nama_bidang_by_id($id_bidang) {
        $this->db->where('id_bidang', $id_bidang);
        $query = $this->db->get('bidang');
        return $query->row();
    }

    public function save_kuesioner_data($responden, $penilaian) 
    {
        $this->db->trans_start();

        // Data untuk tabel 'responden'
        $responden_data = [
            'nama_responden' => $responden['nama_responden'],
            'jenis_kelamin'  => $responden['jenis_kelamin'],
            'nama_bidang'    => $responden['nama_bidang']
        ];
        $this->db->insert('responden', $responden_data);
        $responden_id = $this->db->insert_id();

        // Simpan masukan "Paling Memuaskan" ke tabel pertanyaan_terbuka
        if (!empty($responden['jawaban_memuaskan'])) {
            $data_memuaskan = [
                'id_responden'           => $responden_id,
                'pertanyaan_terbuka_tipe' => 'Paling Memuaskan',
                'jawaban_teks'           => $responden['jawaban_memuaskan']
            ];
            $this->db->insert('pertanyaan_terbuka', $data_memuaskan);
        }

        // Simpan masukan "Perlu Peningkatan" ke tabel pertanyaan_terbuka
        if (!empty($responden['jawaban_peningkatan'])) {
            $data_peningkatan = [
                'id_responden'           => $responden_id,
                'pertanyaan_terbuka_tipe' => 'Perlu Peningkatan',
                'jawaban_teks'           => $responden['jawaban_peningkatan']
            ];
            $this->db->insert('pertanyaan_terbuka', $data_peningkatan);
        }

        // Simpan penilaian (kenyataan dan harapan) ke tabel penilaian_fasilitas
        foreach ($penilaian as $nilai) {
            $data = [
                'id_responden'  => $responden_id,
                'pertanyaan_id' => $nilai['pertanyaan_id'],
                'skala_nilai'   => $nilai['skala_nilai'],
                'harapan'       => $nilai['harapan']
            ];
            $this->db->insert('penilaian_fasilitas', $data);
        }

        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function get_all_pertanyaan()
    {
        $query = $this->db->get('daftar_pertanyaan_fasilitas');
        return $query->result_array();
    }

    public function get_all_bidang() {
        $query = $this->db->get('bidang');
        return $query->result();
    }
}