<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kuesioner extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library(['form_validation', 'session']);
        $this->load->model('Kuesioner_model');
    }

    public function index() 
    {
        $data['pertanyaan'] = $this->Kuesioner_model->get_all_pertanyaan();
        $data['bidang_options'] = $this->Kuesioner_model->get_all_bidang();
        $this->load->view('kuesioner_form', $data);
    }

    public function get_bidang() {
        $term = $this->input->get('term');
        $bidang = $this->Kuesioner_model->search_bidang($term);

        $result = [];
        foreach ($bidang as $row) {
            $result[] = [
                'label' => $row->nama_bidang,
                'value' => $row->id_bidang
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($result);
        exit;
    }

    public function submit() 
    {
        $this->form_validation->set_rules('nama', 'Nama', 'required');
        $this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'required');
        // Ganti validasi 'nama_bidang' menjadi 'id_bidang'
        $this->form_validation->set_rules('id_bidang', 'Nama Bidang', 'required');
        
        // Menambahkan validasi untuk masukan dan saran
        $this->form_validation->set_rules('jawaban_memuaskan', 'Paling Memuaskan', 'required|trim');
        $this->form_validation->set_rules('jawaban_peningkatan', 'Perlu Peningkatan', 'required|trim');

        $pertanyaan = $this->Kuesioner_model->get_all_pertanyaan();

        foreach ($pertanyaan as $p) {
            $this->form_validation->set_rules("harapan[{$p['id_pertanyaan']}]", "Harapan", 'required');
            $this->form_validation->set_rules("kenyataan[{$p['id_pertanyaan']}]", "Kenyataan", 'required');
        }

        if ($this->form_validation->run() == FALSE) {
            $data['pertanyaan'] = $pertanyaan;
            $data['bidang_options'] = $this->Kuesioner_model->get_all_bidang();
            $this->load->view('kuesioner_form', $data);
            return;
        }

        // Ambil nama bidang dari id_bidang yang disubmit
        $id_bidang = $this->input->post('id_bidang');
        $nama_bidang_obj = $this->Kuesioner_model->get_nama_bidang_by_id($id_bidang);
        $nama_bidang = $nama_bidang_obj ? $nama_bidang_obj->nama_bidang : null;

        $responden = [
            'nama_responden' => $this->input->post('nama'),
            'jenis_kelamin'  => $this->input->post('jenis_kelamin'),
            // Pastikan ini juga ada di form jika diperlukan
            'nama_bidang'    => $nama_bidang, // Gunakan nama bidang yang sudah diambil
            'jawaban_memuaskan' => $this->input->post('jawaban_memuaskan'),
            'jawaban_peningkatan' => $this->input->post('jawaban_peningkatan')
        ];

        $input_harapan = $this->input->post('harapan');
        $input_kenyataan = $this->input->post('kenyataan');

        $penilaian = [];
        foreach ($pertanyaan as $p) {
            $id = $p['id_pertanyaan'];
            $penilaian[] = [
                'pertanyaan_id' => $id,
                'harapan' => (int) $input_harapan[$id],
                'skala_nilai' => (int) $input_kenyataan[$id]
            ];
        }

        $success = $this->Kuesioner_model->save_kuesioner_data($responden, $penilaian);

        if ($success) {
            $this->session->set_flashdata('success_msg', 'Terima kasih, kuesioner Anda telah berhasil disimpan!');
            redirect('kuesioner/terimakasih');
        } else {
            $this->session->set_flashdata('error_msg', 'Terjadi kesalahan saat menyimpan, silakan coba lagi.');
            redirect('kuesioner');
        }
    }

    public function terimakasih() {
        $this->load->view('kuesioner_terimakasih');
    }
}