<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Admin_model');
        $this->load->helper('url');
        $this->load->library('session');
    }
    
    public function auth() {
        if ($this->session->userdata('admin')) {
            redirect('admin/dashboard');
        }

        if ($this->input->post()) {
            $username = $this->input->post('username');
            $password = $this->input->post('password');

            $admin = $this->db->get_where('admin', ['username' => $username])->row();

            if ($admin) {
                if ($password === $admin->password) {
                    $this->session->set_userdata('admin', $admin->id);
                    redirect('admin/dashboard');
                } else {
                    $this->session->set_flashdata('error', 'Password salah!');
                }
            } else {
                $this->session->set_flashdata('error', 'Username tidak ditemukan!');
            }

            redirect('admin/auth');
        }

        $this->load->view('admin/login');
    }

    public function dashboard()
    {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        // Ambil data filter dari query string (?bulan=8&tahun=2025)
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');

        // Kirim ke model untuk mendapatkan data yang terfilter
        $data['total_responden'] = $this->Admin_model->count_responden($bulan, $tahun);
        $data['persentase_kepuasan'] = $this->Admin_model->get_persentase_kepuasan_by_bulan_tahun($bulan, $tahun);
        $data['avg_kepuasan'] = $this->Admin_model->get_rata_rata_persentase_per_pertanyaan($bulan, $tahun);
        $data['all_responden'] = $this->Admin_model->get_all_responden($bulan, $tahun);

        // Kirim juga nilai bulan & tahun ke view untuk form select
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun'] = $tahun;

        $this->load->view('admin/dashboard', $data);
    }

    public function logout() {
        $this->session->unset_userdata('admin');
        redirect('admin/auth');
    }

    public function detail($id_responden) {
        $this->load->model('Admin_model');
        $responden = $this->Admin_model->get_responden_by_id($id_responden);
        $penilaian_fasilitas = $this->Admin_model->get_penilaian_by_responden_id($id_responden);
        $jawaban_terbuka = $this->Admin_model->get_pertanyaan_terbuka_by_responden_id($id_responden);

        $data = [
            'responden' => $responden,
            'penilaian_fasilitas' => $penilaian_fasilitas,
            'jawaban_terbuka' => $jawaban_terbuka,
        ];

        $this->load->view('admin/detail', $data);
    }
    
    public function export_responden() {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $search_term = $this->input->get('search'); // Ambil kata kunci pencarian

        // Kirim search_term ke model
        $responden = $this->Admin_model->get_all_responden($bulan, $tahun, $search_term);

        header("Content-type: application/vnd-ms-excel");
        header("Content-Disposition: attachment;filename=data_responden_" . date('Ymd_His') . ".xls");

        echo "<table border='1'>";
        echo "<tr>
                <th>ID</th>
                <th>Nama</th>
                <th>Tanggal</th>
                <th>Domisili</th>
                <th>Jenis Kelamin</th>
            </tr>";
        
        foreach ($responden as $r) {
            echo "<tr>
                    <td>{$r->id_responden}</td>
                    <td>{$r->nama_responden}</td>
                    <td>" . date('d-m-Y', strtotime($r->tanggal_pengisian)) . "</td>
                    <td>{$r->domisili}</td>
                    <td>{$r->jenis_kelamin}</td>
                </tr>";
        }
        echo "</table>";
    }

    public function export_responden_pdf() {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');

        $data['responden'] = $this->Admin_model->get_all_responden($bulan, $tahun);
        $data['bulan'] = $bulan;
        $data['tahun'] = $tahun;

        $this->load->library('pdf');
        $html = $this->load->view('admin/export_pdf', $data, true);
        $this->pdf->loadHtml($html);
        $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->render();
        $this->pdf->stream("data_responden.pdf", array("Attachment"=>false));
    }

     public function responden() {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $search_term = $this->input->get('search'); // Ambil kata kunci pencarian

        $data['judul'] = 'Data Responden';
        // Kirim kata kunci pencarian ke model
        $data['responden'] = $this->Admin_model->get_all_responden($bulan, $tahun, $search_term);
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun'] = $tahun;
        $data['search_term'] = $search_term; // Teruskan kembali ke view

        $this->load->view('admin/responden', $data);
    }
    public function penilaian_fasilitas()
    {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $search_term = $this->input->get('search');


        $data['judul'] = 'Penilaian Fasilitas';
        $data['penilaian'] = $this->Admin_model->get_all_penilaian_fasilitas($bulan, $tahun, $search_term);
        $data['filter_bulan'] = $bulan;

        $data['filter_tahun'] = $tahun;
        $data['search_term'] = $search_term;


        $this->load->view('admin/penilaian_fasilitas', $data); // gunakan view yang sudah diperbaiki
    }

    public function bidang() {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $search_term = $this->input->get('search'); // Tambahkan ini
        
        $data['judul'] = 'Daftar Bidang';
        $data['bidang'] = $this->Admin_model->get_all_bidang($bulan, $tahun, $search_term); // Teruskan search_term ke model
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun'] = $tahun;
        $data['search_term'] = $search_term; // Teruskan kembali ke view
        
        $this->load->view('admin/bidang', $data);
    }

    public function tambah_bidang() {
    // Aturan validasi
    // Tambahkan array pesan kustom pada rules
    $this->form_validation->set_rules(
        'nama_bidang', 
        'Nama Bidang', 
        'required|is_unique[bidang.nama_bidang]',
        array(
            'required' => 'Nama Bidang wajib diisi.',
            'is_unique' => 'Nama Bidang "%s" sudah ada, silakan gunakan nama lain.'
        )
    );

    if ($this->form_validation->run() === FALSE) {
        // Jika validasi gagal, form akan ditampilkan kembali beserta pesan error
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        
        $data['judul'] = 'Tambah Bidang';
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun'] = $tahun;

        $this->load->view('admin/bidang_form', $data);
    } else {
        // Jika validasi berhasil
        $this->Admin_model->insert_bidang($this->input->post('nama_bidang'));
        $this->session->set_flashdata('success', 'Bidang berhasil ditambahkan!');
        redirect('admin/bidang');
    }
}
    public function edit_bidang($id) {
        if ($this->input->post()) {
            $this->Admin_model->update_bidang($id, $this->input->post('nama_bidang'));
            redirect('admin/bidang');
        }
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');

        $data['judul'] = 'Edit Bidang';
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun'] = $tahun;

        $this->load->view('admin/bidang_form', $data);
    }

    public function hapus_bidang($id) {
        $this->Admin_model->delete_bidang($id);
        redirect('admin/bidang');
    }

    public function export_penilaian_fasilitas_excel()
{
    if (!$this->session->userdata('admin')) {
        redirect('admin/auth');
    }

    $bulan = $this->input->get('bulan');
    $tahun = $this->input->get('tahun');

    // Ambil data seperti PDF
    $this->db->select('responden.id_responden, responden.nama_responden, responden.tanggal_pengisian, daftar_pertanyaan_fasilitas.teks_pertanyaan, penilaian_fasilitas.skala_nilai, penilaian_fasilitas.harapan');
    $this->db->from('responden');
    $this->db->join('penilaian_fasilitas', 'penilaian_fasilitas.id_responden = responden.id_responden');
    $this->db->join('daftar_pertanyaan_fasilitas', 'daftar_pertanyaan_fasilitas.id_pertanyaan = penilaian_fasilitas.pertanyaan_id');

    if (!empty($bulan)) {
        $this->db->where('MONTH(responden.tanggal_pengisian)', $bulan);
    }
    if (!empty($tahun)) {
        $this->db->where('YEAR(responden.tanggal_pengisian)', $tahun);
    }

    $result = $this->db->get()->result();

    // Kelompokkan per responden
    $data_penilaian = [];
    foreach ($result as $row) {
        $id = $row->id_responden;
        if (!isset($data_penilaian[$id])) {
            $data_penilaian[$id] = [
                'nama' => $row->nama_responden,
                'tanggal' => $row->tanggal_pengisian,
                'penilaian' => [],
            ];
        }
        $data_penilaian[$id]['penilaian'][] = [
            'pertanyaan' => $row->teks_pertanyaan,
            'skala_nilai' => $row->skala_nilai,
            'harapan' => $row->harapan,
            'persentase' => ($row->harapan > 0) ? round(($row->skala_nilai / $row->harapan) * 100, 2) . '%' : '0%'
        ];
    }

    // Load library Excel
    $this->load->library('excel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);

    // Header
    $sheet->setCellValue('A1', 'No')
          ->setCellValue('B1', 'Nama Responden')
          ->setCellValue('C1', 'Tanggal')
          ->setCellValue('D1', 'Pertanyaan')
          ->setCellValue('E1', 'Skor Kenyataan')
          ->setCellValue('F1', 'Skor Harapan')
          ->setCellValue('G1', 'Persentase (%)');

    // Style header
    $style_header = [
        'font' => ['bold' => true],
        'alignment' => ['horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER],
        'borders' => ['allborders' => ['style' => PHPExcel_Style_Border::BORDER_THIN]],
    ];
    $sheet->getStyle('A1:G1')->applyFromArray($style_header);

    // Isi data
    $rowNum = 2;
    $no = 1;

    foreach ($data_penilaian as $responden) {
        $jumlah = count($responden['penilaian']);
        $startRow = $rowNum;
        $endRow = $rowNum + $jumlah - 1;

        // Merge No, Nama, Tanggal
        $sheet->mergeCells("A{$startRow}:A{$endRow}");
        $sheet->mergeCells("B{$startRow}:B{$endRow}");
        $sheet->mergeCells("C{$startRow}:C{$endRow}");

        $sheet->setCellValue("A{$startRow}", $no);
        $sheet->setCellValue("B{$startRow}", $responden['nama']);
        $sheet->setCellValue("C{$startRow}", date('d-m-Y', strtotime($responden['tanggal'])));

        // Isi detail pertanyaan
        foreach ($responden['penilaian'] as $penilaian) {
            $sheet->setCellValue("D{$rowNum}", $penilaian['pertanyaan']);
            $sheet->setCellValue("E{$rowNum}", $penilaian['skala_nilai']);
            $sheet->setCellValue("F{$rowNum}", $penilaian['harapan']);
            $sheet->setCellValue("G{$rowNum}", $penilaian['persentase']);
            $rowNum++;
        }

        // Border setiap blok responden
        $sheet->getStyle("A{$startRow}:G{$endRow}")
              ->getBorders()->getAllBorders()
              ->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

        $no++;
    }

    // Auto size kolom
    foreach (range('A', 'G') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    // Output file
    $filename = 'penilaian_fasilitas_' . date('Ymd_His') . '.xls';
    header('Content-Type: application/vnd.ms-excel');
    header("Content-Disposition: attachment;filename=\"{$filename}\"");
    header('Cache-Control: max-age=0');

    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
}

    public function export_penilaian_fasilitas_pdf()
    {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }

        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');

        $this->db->select('responden.id_responden, responden.nama_responden, responden.tanggal_pengisian, daftar_pertanyaan_fasilitas.teks_pertanyaan, penilaian_fasilitas.skala_nilai, penilaian_fasilitas.harapan');
        $this->db->from('responden');
        $this->db->join('penilaian_fasilitas', 'penilaian_fasilitas.id_responden = responden.id_responden');
        $this->db->join('daftar_pertanyaan_fasilitas', 'daftar_pertanyaan_fasilitas.id_pertanyaan = penilaian_fasilitas.pertanyaan_id');

        if (!empty($bulan)) {
            $this->db->where('MONTH(responden.tanggal_pengisian)', $bulan);
        }
        if (!empty($tahun)) {
            $this->db->where('YEAR(responden.tanggal_pengisian)', $tahun);
        }

        $result = $this->db->get()->result();

        // Kelompokkan berdasarkan responden
        $data_penilaian = [];
        foreach ($result as $row) {
            $id = $row->id_responden;
            if (!isset($data_penilaian[$id])) {
                $data_penilaian[$id] = [
                    'nama' => $row->nama_responden,
                    'tanggal' => $row->tanggal_pengisian,
                    'penilaian' => [],
                ];
            }

            $data_penilaian[$id]['penilaian'][] = [
                'pertanyaan' => $row->teks_pertanyaan,
                'skala_nilai' => $row->skala_nilai,
                'harapan' => $row->harapan,
            ];
        }

        // Kirim ke view untuk PDF
        $data = [
            'data_penilaian' => $data_penilaian,
            'bulan' => $bulan,
            'tahun' => $tahun,
        ];
        $this->load->view('admin/export_penilaian_fasilitas_pdf', $data);
    }
    public function pertanyaan_fasilitas() {
        if (!$this->session->userdata('admin')) {
            redirect('admin/auth');
        }
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $search_term = $this->input->get('search');
        $data['judul'] = 'Daftar Pertanyaan Fasilitas';
        $data['pertanyaan'] = $this->Admin_model->get_all_daftar_pertanyaan($search_term);
        $data['search_term'] = $search_term;
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun']=$tahun;
        $this->load->view('admin/pertanyaan_fasilitas', $data);
    }

    public function tambah_pertanyaan_fasilitas() {
        if ($this->input->post()) {
            $this->Admin_model->insert_pertanyaan_fasilitas($this->input->post('teks_pertanyaan'));
            redirect('admin/pertanyaan_fasilitas');
        }
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $data['judul'] = 'Tambah Pertanyaan Fasilitas';
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun']=$tahun;
        $this->load->view('admin/form_tambah_pertanyaan_fasilitas', $data);
    }

    public function simpan_pertanyaan_fasilitas() {
        $teks = $this->input->post('teks_pertanyaan');
        $this->db->insert('daftar_pertanyaan_fasilitas', ['teks_pertanyaan' => $teks]);
        redirect('admin/pertanyaan_fasilitas');
    }

    public function edit_pertanyaan_fasilitas($id) {
        if ($this->input->post()) {
            $this->Admin_model->update_pertanyaan_fasilitas($id, $this->input->post('teks_pertanyaan'));
            redirect('admin/pertanyaan_fasilitas');
        }
        $bulan = $this->input->get('bulan');
        $tahun = $this->input->get('tahun');
        $data['pertanyaan'] = $this->db->get_where('daftar_pertanyaan_fasilitas', ['id_pertanyaan' => $id])->row();
        $data['judul'] = 'Edit Pertanyaan Fasilitas';
        $data['filter_bulan'] = $bulan;
        $data['filter_tahun']=$tahun;
        $this->load->view('admin/form_edit_pertanyaan_fasilitas', $data);
    }

    public function update_pertanyaan_fasilitas($id) {
        $teks = $this->input->post('teks_pertanyaan');
        $this->db->where('id_pertanyaan', $id)->update('daftar_pertanyaan_fasilitas', ['teks_pertanyaan' => $teks]);
        redirect('admin/pertanyaan_fasilitas');
    }

    public function hapus_pertanyaan_fasilitas($id) {
    // Hapus dulu data penilaian yang terkait
    $this->db->where('pertanyaan_id', $id);
    $this->db->delete('penilaian_fasilitas');

    // Hapus pertanyaannya
    $this->db->where('id_pertanyaan', $id);
    $this->db->delete('daftar_pertanyaan_fasilitas');

    redirect('admin/pertanyaan_fasilitas');
}
public function pertanyaan_terbuka() {
    // Cek apakah admin sudah login
    if (!$this->session->userdata('admin')) {
        redirect('admin/auth');
    }
    
    // Ambil nilai dari URL
    $bulan = $this->input->get('bulan');
    $tahun = $this->input->get('tahun');
    $search_term = $this->input->get('search');
    
    // Ambil data pertanyaan terbuka dari model,
    // dan **teruskan parameter filter** ke fungsi model
    $data['judul'] = 'Pertanyaan Terbuka';
    $data['jawaban_terbuka_gabung'] = $this->Admin_model->get_all_pertanyaan_terbuka_grouped($bulan, $tahun, $search_term); 
    $data['search_term'] = $search_term;
    $data['filter_bulan'] = $bulan;
    $data['filter_tahun'] = $tahun;

    // Tampilkan view
    $this->load->view('admin/pertanyaan_terbuka', $data);
}
public function export_pertanyaan_terbuka_excel()
{
    if (!$this->session->userdata('admin')) {
        redirect('admin/auth');
    }

    $this->load->library('excel');
    $objPHPExcel = new PHPExcel();
    $sheet = $objPHPExcel->setActiveSheetIndex(0);

    // Header
    $sheet->setCellValue('A1', 'No')
          ->setCellValue('B1', 'Nama Responden')
          ->setCellValue('C1', 'Tanggal')
          ->setCellValue('D1', 'Jawaban Paling Memuaskan')
          ->setCellValue('E1', 'Jawaban Perlu Peningkatan');

    $style_header = [
        'font' => ['bold' => true],
        'alignment' => ['horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER],
        'borders' => ['allborders' => ['style' => PHPExcel_Style_Border::BORDER_THIN]],
    ];
    $sheet->getStyle('A1:E1')->applyFromArray($style_header);

    // Data
    $data = $this->Admin_model->get_all_pertanyaan_terbuka_grouped();
    $rowNum = 2;
    $no = 1;
    foreach ($data as $row) {
        $sheet->setCellValue("A{$rowNum}", $no++)
              ->setCellValue("B{$rowNum}", $row->nama_responden)
              ->setCellValue("C{$rowNum}", date('d-m-Y', strtotime($row->tanggal_pengisian)))
              ->setCellValue("D{$rowNum}", $row->jawaban_memuaskan)
              ->setCellValue("E{$rowNum}", $row->jawaban_peningkatan);
        $rowNum++;
    }

    // Auto size kolom
    foreach (range('A', 'E') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    // Output file XLSX asli
    $filename = 'pertanyaan_terbuka_' . date('Ymd_His') . '.xlsx';
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=\"{$filename}\"");
    header('Cache-Control: max-age=0');

    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save('php://output');
}


public function export_pertanyaan_terbuka_pdf()
{
    if (!$this->session->userdata('admin')) {
        redirect('admin/auth');
    }

    $this->load->library('pdf');
    $data['jawaban_terbuka_gabung'] = $this->Admin_model->get_all_pertanyaan_terbuka_grouped();
    $html = $this->load->view('admin/export_pertanyaan_terbuka_pdf', $data, true);
    $this->pdf->loadHtml($html);
    $this->pdf->setPaper('A4', 'portrait');
    $this->pdf->render();
    $this->pdf->stream("pertanyaan_terbuka.pdf", array("Attachment"=>false));
}


}