<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard Admin | Kuesioner</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Tailwind CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f9fafb;
        }
    </style>
</head>
<body class="min-h-screen">

<!-- Header -->
<header class="bg-white shadow-md sticky top-0 z-50">
    <div class="max-w-7xl mx-auto px-6 py-4 flex items-center justify-between">

        <!-- Kiri: Logo + Judul + Navigasi -->
        <div class="flex items-center space-x-10">
            <!-- Logo + Judul -->
            <div class="flex items-center space-x-3">
                <img src="<?= base_url('assets/img/logo.png') ?>" alt="Logo" class="h-10 w-10 rounded-full">
                <h1 class="text-xl font-semibold text-gray-800">Admin Panel</h1>
            </div>
            <!-- Navigasi -->
            <nav class="flex space-x-6 text-base font-medium">
                <a href="<?= base_url('index.php/admin/dashboard') ?>" class="text-gray-700 hover:text-blue-500">Dashboard</a>
                <a href="<?= base_url('index.php/admin/responden') ?>" class="text-gray-700 hover:text-blue-500">Responden</a>
            </nav>
        </div>

        <!-- Kanan: Filter + Logout -->
        <div class="flex items-center space-x-4">
            <form method="get" action="<?= current_url(); ?>" class="flex items-end space-x-2 text-base">
                <div>
                    <label for="bulan" class="block text-sm font-medium text-gray-700">Bulan</label>
                    <select name="bulan" id="bulan" class="rounded border-gray-300 text-base">
                        <option value="">Semua</option>
                        <?php for ($i = 1; $i <= 12; $i++): ?>
                            <option value="<?= $i ?>" <?= ($filter_bulan == $i) ? 'selected' : '' ?>>
                                <?= date('F', mktime(0, 0, 0, $i, 10)) ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div>
                    <label for="tahun" class="block text-sm font-medium text-gray-700">Tahun</label>
                    <select name="tahun" id="tahun" class="rounded border-gray-300 text-base">
                        <option value="">Semua</option>
                        <?php for ($t = date('Y'); $t >= 2020; $t--): ?>
                            <option value="<?= $t ?>" <?= ($filter_tahun == $t) ? 'selected' : '' ?>>
                                <?= $t ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg text-sm">
                    Terapkan
                </button>
            </form>

            <a href="<?= base_url('index.php/admin/logout') ?>" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                Logout
            </a>
        </div>
    </div>
</header>



<!-- Content wrapper -->
<main class="px-6 py-6 max-w-7xl mx-auto">
